/*
	File:		PlayerAPI.c

	Contains:	

	Written by:	Jeff Robbin

	Copyright:	Copyright 1998 Jeff Robbin
*/


#include "SoundJamAPI.h"


// MemClear
//
static void MemClear (LogicalAddress dest, SInt32 length)
{
	register unsigned char	*ptr;

	ptr = (unsigned char *) dest;
	
	if( length > 16 )
	{
		register unsigned long	*longPtr;
		
		while( ((unsigned long) ptr & 3) != 0 )
		{
			*ptr++ = 0;
			--length;
		}
		
		longPtr = (unsigned long *) ptr;
		
		while( length >= 4 )
		{
			*longPtr++ 	= 0;
			length		-= 4;
		}
		
		ptr = (unsigned char *) longPtr;
	}
	
	while( --length >= 0 )
	{
		*ptr++ = 0;
	}
}


// CallSoundJam
//
static OSStatus CallSoundJam (void *appCookie, SoundJamProcPtr handler, OSType message, PlayerMessageInfo *messageInfo)
{
	PlayerMessageInfo	localMessageInfo;
	
	if (messageInfo == nil)
	{
		MemClear(&localMessageInfo, sizeof(localMessageInfo));
		
		messageInfo = &localMessageInfo;
	}
	
	messageInfo->version = kCurrentPluginMessageVersion;
	
	return handler(appCookie, message, messageInfo);
}


// PlayerSetPreference
//
OSStatus PlayerSetPreference (void *appCookie, SoundJamProcPtr playerHandler, OSType preference, UInt32 value)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.preferenceMessage.preference	= preference;
	messageInfo.u.preferenceMessage.value		= value;

	return CallSoundJam(appCookie, playerHandler, kPlayerSetPreferenceMessage, &messageInfo);
}


// PlayerGetPreference
//
OSStatus PlayerGetPreference (void *appCookie, SoundJamProcPtr playerHandler, OSType preference, UInt32 *value)
{
	OSStatus			status;
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.preferenceMessage.preference	= preference;

	status = CallSoundJam(appCookie, playerHandler, kPlayerGetPreferenceMessage, &messageInfo);
	
	if ((value != nil) && (status == noErr))
		*value = messageInfo.u.preferenceMessage.value;
	
	return status;
}


// PlayerSetFullScreen
//
OSStatus PlayerSetFullScreen (void *appCookie, SoundJamProcPtr playerHandler, Boolean fullScreen)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.setFullScreenMessage.fullScreen = fullScreen;

	return CallSoundJam(appCookie, playerHandler, kPlayerSetFullScreenMessage, &messageInfo);
}


// PlayerSetFullScreenOptions
//
OSStatus PlayerSetFullScreenOptions (void *appCookie, SoundJamProcPtr playerHandler, SInt16 minBitDepth, SInt16 maxBitDepth, SInt16 preferredBitDepth, SInt16 desiredWidth, SInt16 desiredHeight)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.setFullScreenOptionsMessage.minBitDepth		= minBitDepth;
	messageInfo.u.setFullScreenOptionsMessage.maxBitDepth		= maxBitDepth;
	messageInfo.u.setFullScreenOptionsMessage.preferredBitDepth = preferredBitDepth;
	messageInfo.u.setFullScreenOptionsMessage.desiredWidth		= desiredWidth;
	messageInfo.u.setFullScreenOptionsMessage.desiredHeight		= desiredHeight;

	return CallSoundJam(appCookie, playerHandler, kPlayerSetFullScreenOptionsMessage, &messageInfo);
}


// PlayerSetDefaultWindowSize
//
OSStatus PlayerSetDefaultWindowSize (	void *			appCookie,
										SoundJamProcPtr	playerHandler,
										SInt16			defaultWidth,
										SInt16			defaultHeight,
										SInt16			minWidth,
										SInt16			minHeight,
										SInt16			maxWidth,
										SInt16			maxHeight)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.setDefaultWindowSizeMessage.defaultWidth	= defaultWidth;
	messageInfo.u.setDefaultWindowSizeMessage.defaultHeight	= defaultHeight;

	messageInfo.u.setDefaultWindowSizeMessage.minWidth		= minWidth;
	messageInfo.u.setDefaultWindowSizeMessage.minHeight		= minHeight;

	messageInfo.u.setDefaultWindowSizeMessage.maxWidth		= maxWidth;
	messageInfo.u.setDefaultWindowSizeMessage.maxHeight		= maxHeight;

	return CallSoundJam(appCookie, playerHandler, kPlayerSetDefaultWindowSizeMessage, &messageInfo);
}


// PlayerShowHideEQWindow
//
void PlayerShowHideEQWindow (void *appCookie, SoundJamProcPtr playerHandler, Boolean showWindow)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.showHideMessage.showWindow = showWindow;

	(void) CallSoundJam(appCookie, playerHandler, kPlayerShowHideEQMessage, &messageInfo);
}


// PlayerShowHidePlaylistWindow
//
void PlayerShowHidePlaylistWindow (void *appCookie, SoundJamProcPtr playerHandler, Boolean showWindow)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.showHideMessage.showWindow = showWindow;

	(void) CallSoundJam(appCookie, playerHandler, kPlayerShowHidePlaylistMessage, &messageInfo);
}


// PlayerDragWindow
//
void PlayerDragWindow (void *appCookie, SoundJamProcPtr playerHandler, WindowPtr window, Point globalWhere)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.dragWindowMessage.window		= window;
	messageInfo.u.dragWindowMessage.globalWhere	= globalWhere;
	
	CallSoundJam(appCookie, playerHandler, kPlayerDragWindowMessage, &messageInfo);
}


// PlayerGetPluginData
//
OSStatus PlayerGetPluginData (void *appCookie, SoundJamProcPtr playerHandler, void *dataPtr, UInt32 dataBufferSize, UInt32 *dataSize)
{
	OSStatus			status;
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.getPluginDataMessage.dataPtr			= dataPtr;
	messageInfo.u.getPluginDataMessage.dataBufferSize	= dataBufferSize;
	
	status = CallSoundJam(appCookie, playerHandler, kPlayerGetPluginDataMessage, &messageInfo);
	
	if (dataSize != nil)
		*dataSize = messageInfo.u.getPluginDataMessage.dataSize;
	
	return status;
}


// PlayerSetPluginData
//
OSStatus PlayerSetPluginData (void *appCookie, SoundJamProcPtr playerHandler, void *dataPtr, UInt32 dataSize)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.setPluginDataMessage.dataPtr	= dataPtr;
	messageInfo.u.setPluginDataMessage.dataSize	= dataSize;
	
	return CallSoundJam(appCookie, playerHandler, kPlayerSetPluginDataMessage, &messageInfo);
}


// PlayerIdle
//
OSStatus PlayerIdle (void *appCookie, SoundJamProcPtr playerHandler)
{
	return CallSoundJam(appCookie, playerHandler, kPlayerIdleMessage, nil);
}


OSStatus PlayerDoneTrack (void *appCookie, SoundJamProcPtr playerHandler)
{
	return CallSoundJam(appCookie, playerHandler, kPlayerDoneTrackMessage, nil);
}


// PlayerPlayTrack
//
OSStatus PlayerPlayTrack (void *appCookie, SoundJamProcPtr playerHandler)
{
	return CallSoundJam(appCookie, playerHandler, kPlayerPlayTrackMessage, nil);
}


// PlayerStopTrack
//
OSStatus PlayerStopTrack (void *appCookie, SoundJamProcPtr playerHandler)
{
	return CallSoundJam(appCookie, playerHandler, kPlayerStopTrackMessage, nil);
}


// PlayerPauseTrack
//
OSStatus PlayerPauseTrack (void *appCookie, SoundJamProcPtr playerHandler)
{
	return CallSoundJam(appCookie, playerHandler, kPlayerPauseTrackMessage, nil);
}


// PlayerNextTrack
//
OSStatus PlayerNextTrack (void *appCookie, SoundJamProcPtr playerHandler)
{
	return CallSoundJam(appCookie, playerHandler, kPlayerNextTrackMessage, nil);
}


// PlayerPrevTrack
//
OSStatus PlayerPrevTrack (void *appCookie, SoundJamProcPtr playerHandler)
{
	return CallSoundJam(appCookie, playerHandler, kPlayerPrevTrackMessage, nil);
}


// PlayerLoadTrack
//
OSStatus PlayerLoadTrack (void *appCookie, SoundJamProcPtr playerHandler)
{
	return CallSoundJam(appCookie, playerHandler, kPlayerLoadTrackMessage, nil);
}


// PlayerOpenPrefs
//
void PlayerOpenPrefs (void *appCookie, SoundJamProcPtr playerHandler)
{
	CallSoundJam(appCookie, playerHandler, kPlayerOpenPrefsMessage, nil);
}


// PlayerCloseWindow
//
void PlayerCloseWindow (void *appCookie, SoundJamProcPtr playerHandler, WindowPtr window)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));

	messageInfo.u.closeWindowMessage.window	= window;

	CallSoundJam(appCookie, playerHandler, kPlayerCloseWindowMessage, &messageInfo);
}


// PlayerMinimizeWindow
//
void PlayerMinimizeWindow (void *appCookie, SoundJamProcPtr playerHandler, WindowPtr window, Boolean isMinimized)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));

	messageInfo.u.minimizeWindowMessage.window		= window;
	messageInfo.u.minimizeWindowMessage.minimized	= isMinimized;

	CallSoundJam(appCookie, playerHandler, kPlayerMinimizeWindowMessage, &messageInfo);
}


// PlayerSetTrackPosition
//
OSStatus PlayerSetTrackPosition (void *appCookie, SoundJamProcPtr playerHandler, UInt32 positionInMS)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.setTrackPositionMessage.positionInMS	= positionInMS;

	return CallSoundJam(appCookie, playerHandler, kPlayerSetTrackPositionMessage, &messageInfo);
}


// PlayerSetVolumeBalance
//
OSStatus PlayerSetVolumeBalance (void *appCookie, SoundJamProcPtr playerHandler, SInt32 volume, SInt32 balance)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.setVolumeBalanceMessage.volume	= volume;
	messageInfo.u.setVolumeBalanceMessage.balance	= balance;

	return CallSoundJam(appCookie, playerHandler, kPlayerSetVolumeBalanceMessage, &messageInfo);
}


// PlayerSetTrebleBass
//
OSStatus PlayerSetTrebleBass (void *appCookie, SoundJamProcPtr playerHandler, SInt32 treble, SInt32 bass)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.setTrebleBassMessage.treble	= treble;
	messageInfo.u.setTrebleBassMessage.bass	= bass;

	return CallSoundJam(appCookie, playerHandler, kPlayerSetTrebleBassMessage, &messageInfo);
}


// PlayerShowAbout
//
void PlayerShowAbout (void *appCookie, SoundJamProcPtr playerHandler)
{
	CallSoundJam(appCookie, playerHandler, kPlayerShowAboutMessage, nil);
}


// PlayerOpenURL
//
void PlayerOpenURL (void *appCookie, SoundJamProcPtr playerHandler, SInt8 *string, UInt32 length)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.openURLMessage.url	= string;
	messageInfo.u.openURLMessage.length	= length;

	CallSoundJam(appCookie, playerHandler, kPlayerOpenURLMessage, &messageInfo);
}


// PlayerSetEQLevel
//
OSStatus PlayerSetEQLevel (void *appCookie, SoundJamProcPtr playerHandler, UInt32 band, SInt32 level)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.setEQLevelMessage.band	= band;
	messageInfo.u.setEQLevelMessage.level	= level;

	return CallSoundJam(appCookie, playerHandler, kPlayerSetEQLevelMessage, &messageInfo);
}


// PlayerSetEQOptions
//
OSStatus PlayerSetEQOptions (void *appCookie, SoundJamProcPtr playerHandler, OptionBits options)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.setEQOptionsMessage.options	= options;

	return CallSoundJam(appCookie, playerHandler, kPlayerSetEQOptionsMessage, &messageInfo);
}


// PlayerPopupEQPresetsMenu
//
OSStatus PlayerPopupEQPresetsMenu (void *appCookie, SoundJamProcPtr playerHandler, Point localPt)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.popupEQPresetsMenuMessage.localPt	= localPt;

	return CallSoundJam(appCookie, playerHandler, kPlayerPopupEQPresetsMenuMessage, &messageInfo);
}


// PlayerDecodeDone
//
void PlayerDecodeDone (void *appCookie, SoundJamProcPtr playerHandler, void *playerCookie, OSStatus readStatus, OSStatus decodeStatus, UInt32 numSamples)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.decodeDoneMessage.playerCookie	= playerCookie;
	messageInfo.u.decodeDoneMessage.readStatus		= readStatus;
	messageInfo.u.decodeDoneMessage.decodeStatus	= decodeStatus;
	messageInfo.u.decodeDoneMessage.numSamples		= numSamples;
	
	CallSoundJam(appCookie, playerHandler, kPlayerDecodeDoneMessage, &messageInfo);
}


// PlayerExtractProgress
//
OSStatus PlayerExtractProgress (void *appCookie, SoundJamProcPtr playerHandler, void *extractCookie, UInt32 progressInMS)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.extractProgressMessage.extractCookie	= extractCookie;
	messageInfo.u.extractProgressMessage.progressInMS	= progressInMS;
	
	return CallSoundJam(appCookie, playerHandler, kPlayerExtractProgressMessage, &messageInfo);
}


// PlayerRegisterVisualPlugin
//
OSStatus PlayerRegisterVisualPlugin (void *appCookie, SoundJamProcPtr playerHandler, PlayerMessageInfo *messageInfo)
{			
	return CallSoundJam(appCookie, playerHandler, kPlayerRegisterVisualPluginMessage, messageInfo);
}



// PlayerRegisterPlayerPlugin
//
OSStatus PlayerRegisterPlayerPlugin (void *appCookie, SoundJamProcPtr playerHandler, PlayerMessageInfo *messageInfo)
{			
	return CallSoundJam(appCookie, playerHandler, kPlayerRegisterPlayerPluginMessage, messageInfo);
}



// PlayerRegisterEncoderPlugin
//
OSStatus PlayerRegisterEncoderPlugin (void *appCookie, SoundJamProcPtr playerHandler, PlayerMessageInfo *messageInfo)
{			
	return CallSoundJam(appCookie, playerHandler, kPlayerRegisterEncoderPluginMessage, messageInfo);
}


// PlayerRegisterSkinPlugin
//
OSStatus PlayerRegisterSkinPlugin (void *appCookie, SoundJamProcPtr playerHandler, PlayerMessageInfo *messageInfo)
{			
	return CallSoundJam(appCookie, playerHandler, kPlayerRegisterSkinPluginMessage, messageInfo);
}


// PlayerRegisterDevicePlugin
//
OSStatus PlayerRegisterDevicePlugin (void *appCookie, SoundJamProcPtr playerHandler, PlayerMessageInfo *messageInfo)
{			
	return CallSoundJam(appCookie, playerHandler, kPlayerRegisterDevicePluginMessage, messageInfo);
}


// PlayerUnregisterPlugin
//
OSStatus PlayerUnregisterPlugin (void *appCookie, SoundJamProcPtr playerHandler, PlayerMessageInfo *messageInfo)
{
	return CallSoundJam(appCookie, playerHandler, kPlayerUnregisterPluginMessage, messageInfo);
}


// PlayerQueueDeferredTask
//
OSStatus PlayerInstallDeferredTask (void *appCookie, SoundJamProcPtr playerHandler, DeferredTask *dTask)
{
	PlayerMessageInfo	messageInfo;
	
	MemClear(&messageInfo, sizeof(messageInfo));
	
	messageInfo.u.installDeferredTaskMessage.deferredTask = dTask;
		
	return CallSoundJam(appCookie, playerHandler, kPlayerInstallDeferredTaskMessage, &messageInfo);
}
